//
//  InsuredMemberTableViewCell.m
//  Open
//
//  Created by 雷俊博 on 2019/8/3.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "InsuredMemberTableViewCell.h"
#import "Constants.h"
#import "UIColor+Hex.h"

@interface InsuredMemberTableViewCell ()

@property (nonatomic, strong)UIView *view_icon;

@property (nonatomic, strong)UILabel *lb_iconName;

@property (nonatomic, strong)UILabel *lb_name;

@property (nonatomic, strong)UILabel *lb_IdNum;

@property (nonatomic, strong)UIButton *btn_modification;

@property (nonatomic, strong)UIButton *btn_delete;

@property (nonatomic, strong)UIButton *btn_selected;



@end
@implementation InsuredMemberTableViewCell
#pragma mark - life cycle
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self addSubview:self.view_icon];
        [self addSubview:self.lb_name];
        [self addSubview:self.lb_IdNum];
        [self addSubview:self.btn_selected];
        [self addSubview:self.btn_delete];
        [self addSubview:self.btn_modification];
        self.layer.cornerRadius = 10 * WIDTHRADIU;
        //self.layer.masksToBounds = YES;
        self.layer.shadowColor = [UIColor colorWithHex:0x1886d3].CGColor;
        self.layer.shadowOffset = CGSizeMake(0, 0);
        self.layer.shadowOpacity = 0.2;
        self.layer.shadowRadius = 2 * WIDTHRADIU;
        [self setupUI];
        
        [self setHidden:YES];
    }
    return self;
}

- (void)setupUI
{
    [self.view_icon mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self);
        make.left.offset(20 * WIDTHRADIU);
        make.width.height.offset(45 * WIDTHRADIU);
    }];
    
    [self.lb_iconName mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.equalTo(self.view_icon);
    }];
    
    
    [self.lb_name mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view_icon.mas_top).offset(1.5 * WIDTHRADIU);
        make.left.equalTo(self.view_icon.mas_right).offset(10 * WIDTHRADIU);
        make.height.offset(18 * WIDTHRADIU);
    }];
    
    [self.lb_IdNum mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.lb_name);
        make.bottom.equalTo(self.view_icon.mas_bottom).offset(-1.5 * WIDTHRADIU);
        make.height.offset(14 * WIDTHRADIU);
    }];
    
    [self.btn_selected mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self);
        make.right.offset(- 20 * WIDTHRADIU);
        make.width.height.offset(16 * WIDTHRADIU);
    }];
    
    [self.btn_delete mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self);
        make.right.offset(- 20 * WIDTHRADIU);
        make.width.height.offset(30 * WIDTHRADIU);
    }];
    [self.btn_modification mas_makeConstraints:^(MASConstraintMaker *make) {
         make.centerY.equalTo(self);
        make.right.equalTo(self.btn_delete.mas_left).offset(- 40 * WIDTHRADIU);
        make.width.height.offset(30 * WIDTHRADIU);
    }];
}

- (void)setFrame:(CGRect)frame{
    frame.origin.x += 10 * WIDTHRADIU;
    frame.origin.y += 15 * WIDTHRADIU;
    frame.size.height -= 20* WIDTHRADIU;
    frame.size.width -= 20*WIDTHRADIU;
    [super setFrame:frame];
}

#pragma mark - getters and setters

- (void)setHidden:(BOOL)hidden
{
        self.btn_delete.hidden = hidden;
        self.btn_modification.hidden = hidden;
        self.btn_selected.hidden = !hidden;
}
- (UIView *)view_icon
{
    if (!_view_icon) {
        _view_icon = [[UIView alloc]init];
        _view_icon.layer.cornerRadius = 22.5 * WIDTHRADIU;
        _view_icon.layer.masksToBounds = YES;
        _view_icon.backgroundColor = [UIColor colorWithHex:0x1886d3];
        [_view_icon addSubview:self.lb_iconName];
    }
    return _view_icon;
}

- (UILabel *)lb_iconName
{
    if (!_lb_iconName) {
        _lb_iconName = [[UILabel alloc]init];
        _lb_iconName.text = @"姥姥";
        _lb_iconName.textAlignment = NSTextAlignmentCenter;
        _lb_iconName.textColor = [UIColor whiteColor];
        _lb_iconName.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
    }
    return _lb_iconName;
}

- (UILabel *)lb_name
{
    if (!_lb_name) {
        _lb_name = [[UILabel alloc]init];
        _lb_name.text = @"刘姥姥";
        _lb_name.textColor = [UIColor colorWithHex:0x1886d3];
        _lb_name.font = [UIFont systemFontOfSize:18 * WIDTHRADIU];
    }
    return _lb_name;
}

- (UILabel *)lb_IdNum
{
    if (!_lb_IdNum) {
        _lb_IdNum = [[UILabel alloc]init];
        _lb_IdNum.text = @"34**************2X";
        _lb_IdNum.textColor = [UIColor colorWithHex:0x1886d3];
        _lb_name.font = [UIFont systemFontOfSize:14 * WIDTHRADIU];
    }
    return _lb_IdNum;
}

- (UIButton *)btn_selected
{
    if (!_btn_selected) {
        _btn_selected = [UIButton buttonWithType:UIButtonTypeCustom];
        _btn_selected.backgroundColor = [UIColor colorWithHex:0x1886d3];
    }
    return _btn_selected;
}

- (UIButton *)btn_delete
{
    if (!_btn_delete) {
        _btn_delete = [UIButton buttonWithType:UIButtonTypeCustom];
        _btn_delete.backgroundColor = [UIColor colorWithHex:0x808080];
    }
    return _btn_delete;
}

- (UIButton *)btn_modification
{
    if (!_btn_modification) {
        _btn_modification = [UIButton buttonWithType:UIButtonTypeCustom];
        _btn_modification.backgroundColor = [UIColor colorWithHex:0x808080];
    }
    return _btn_modification;
}


- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
